from solvers import *
import matplotlib.pyplot as plt
# Run K times and plot
def exp(K):
    dic = {"x_dim": 10, "constraint_dim": 2, "A_range": [0, 2], "a_range": [0, 1]}
    RECOO_loss = []
    RECOO_constraint = []
    Alg_Yi_loss = []
    Alg_Yi_constraint = []

    def listmean(a, b):
        c = []
        for i in range(len(a)):
            c.append(a[i] / b)
        return c

    def list_add(a, b):
        c = []
        for i in range(len(a)):
            c.append(a[i] + b[i])
        return c

    for _ in range(K):
        prob = COCO(dictionary = dic)

        # RECOO exp
        a = RECOO(problem = prob)
        a.run()
        RECOO_loss.append(a.loss_list)
        RECOO_constraint.append(a.constraint_violation_list)
        print(a.constraint_violation_list)

        # Alg_Yi exp
        b = Alg_Yi(problem=prob)
        b.run()
        Alg_Yi_loss.append(b.loss_list)
        Alg_Yi_constraint.append(b.constraint_violation_list)

    RECOOloss_mean = RECOO_loss[0]
    for i in range(1,K):
        RECOOloss_mean = list_add(RECOOloss_mean,RECOO_loss[i])
    RECOOloss_mean = listmean(RECOOloss_mean,K)

    RECOOcon_mean = RECOO_constraint[0]
    for i in range(1,K):
        RECOOcon_mean = list_add(RECOOcon_mean,RECOO_constraint[i])
    RECOOcon_mean = listmean(RECOOcon_mean,K)

    Alg_Yiloss_mean = Alg_Yi_loss[0]
    for i in range(1,K):
        Alg_Yiloss_mean = list_add(Alg_Yiloss_mean,Alg_Yi_loss[i])
    Alg_Yiloss_mean = listmean(Alg_Yiloss_mean,K)

    Alg_Yiconstraint_mean = Alg_Yi_constraint[0]
    for i in range(1,K):
        Alg_Yiconstraint_mean = list_add(Alg_Yiconstraint_mean,Alg_Yi_constraint[i])
    Alg_Yiconstraint_mean = listmean(Alg_Yiconstraint_mean,K)

    plt.plot(RECOOloss_mean, label="RPCOO", linewidth=2.0)
    plt.plot(Alg_Yiloss_mean, label="Algorithm 1 in [27]", linewidth=2.0)
    plt.xlabel("Rounds", fontsize=18)
    plt.ylabel("Loss", fontsize=18)
    plt.legend(fontsize=13)
    plt.tick_params(labelsize=13)
    plt.show()

    plt.plot(RECOOcon_mean, label="RPCOO", linewidth=2.0)
    plt.plot(Alg_Yiconstraint_mean, label="Algorithm 1 in [27]", linewidth=2.0)
    plt.xlabel("Rounds", fontsize=18)
    plt.ylabel("Constraint Violation", fontsize=18)
    plt.legend(fontsize=13)
    plt.tick_params(labelsize=13)
    plt.show()

if __name__ == '__main__':
    trial = 1
    exp(trial)







